/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.ExecVarDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ActionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.SequenceDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeInterfaceTypeChangeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeInterfaceTypeChangeDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.TypeTypeNode;
import de.unika.ipd.grgen.ast.type.basic.UntypedExecVarTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTripleResolver;
import de.unika.ipd.grgen.ast.util.Triple;
import de.unika.ipd.grgen.ir.Bad;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.parser.Symbol;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class CallActionNode
extends BaseNode {
    private IdentNode actionUnresolved;
    private CollectNode<BaseNode> paramsUnresolved;
    private CollectNode<BaseNode> returnsUnresolved;
    private CollectNode<BaseNode> filterFunctionsUnresolved;
    private boolean isAllBracketed;
    private ActionDeclNode action;
    private SequenceDeclNode sequence;
    private ExecVarDeclNode boolVar;
    public CollectNode<ExprNode> params;
    protected CollectNode<ExecVarDeclNode> returns;
    protected CollectNode<FilterFunctionDeclNode> filterFunctions;
    private static final DeclarationTripleResolver<ActionDeclNode, SequenceDeclNode, ExecVarDeclNode> actionResolver;
    private static final CollectResolver<ExprNode> paramNodeResolver;
    private static final CollectResolver<ExecVarDeclNode> varDeclNodeResolver;
    private static final CollectResolver<FilterFunctionDeclNode> filterResolver;

    public CallActionNode(Coords coords, IdentNode identNode, CollectNode<BaseNode> collectNode, CollectNode<BaseNode> collectNode2, CollectNode<BaseNode> collectNode3, boolean bl) {
        super(coords);
        this.actionUnresolved = identNode;
        this.paramsUnresolved = collectNode;
        this.returnsUnresolved = collectNode2;
        this.filterFunctionsUnresolved = collectNode3;
        this.isAllBracketed = bl;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.actionUnresolved, this.action, this.sequence, this.boolVar));
        vector.add(this.getValidVersion(this.paramsUnresolved, this.params));
        vector.add(this.getValidVersion(this.returnsUnresolved, this.returns));
        vector.add(this.getValidVersion(this.filterFunctionsUnresolved, this.filterFunctions));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("action");
        vector.add("params");
        vector.add("returns");
        vector.add("filter");
        return vector;
    }

    protected CollectNode<ExprNode> getParams() {
        assert (this.isResolved());
        return this.params;
    }

    public ActionDeclNode getAction() {
        return this.action;
    }

    public void addImplicitDefinitions() {
        for (int i = 0; i < this.returnsUnresolved.size(); ++i) {
            if (!(this.returnsUnresolved.get(i) instanceof IdentNode)) continue;
            IdentNode identNode = (IdentNode)this.returnsUnresolved.get(i);
            debug.report(4, "Implicit definition for " + identNode + " in scope " + this.getScope());
            Symbol.Definition definition = this.getScope().getCurrDef(identNode.getSymbol());
            debug.report(4, "definition is: " + definition);
            if (definition.isValid()) {
                identNode.setSymDef(definition);
                continue;
            }
            Symbol.Definition definition2 = this.getScope().define(identNode.getSymbol(), identNode.getCoords());
            identNode.setSymDef(definition2);
            definition2.setNode(identNode);
            this.getScope().leaveScope();
            ExecVarDeclNode execVarDeclNode = new ExecVarDeclNode(identNode, BasicTypeNode.untypedType);
            identNode.setDecl(execVarDeclNode);
            this.returnsUnresolved.set(i, execVarDeclNode);
        }
    }

    @Override
    protected boolean resolveLocal() {
        Object object;
        boolean bl = true;
        this.addImplicitDefinitions();
        if (!(this.actionUnresolved instanceof PackageIdentNode)) {
            CallActionNode.fixupDefinition(this.actionUnresolved, this.actionUnresolved.getScope());
        }
        if ((object = actionResolver.resolve(this.actionUnresolved, this)) != null) {
            if (((Triple)object).first != null) {
                this.action = (ActionDeclNode)((Triple)object).first;
            } else if (((Triple)object).second != null) {
                this.sequence = (SequenceDeclNode)((Triple)object).second;
            } else {
                this.boolVar = (ExecVarDeclNode)((Triple)object).third;
            }
        }
        bl &= object != null && (this.action != null || this.sequence != null || this.boolVar != null);
        if (this.action != null) {
            for (BaseNode baseNode : this.filterFunctionsUnresolved.getChildren()) {
                if (baseNode instanceof PackageIdentNode || CallActionNode.tryFixupDefinition(baseNode, this.action.getScope().getParent())) continue;
                CallActionNode.fixupDefinition(baseNode, baseNode.getScope());
            }
        }
        this.params = paramNodeResolver.resolve(this.paramsUnresolved, this);
        bl &= this.params != null;
        this.returns = varDeclNodeResolver.resolve(this.returnsUnresolved, this);
        bl &= this.returns != null;
        this.filterFunctions = filterResolver.resolve(this.filterFunctionsUnresolved, this);
        return bl &= this.filterFunctions != null;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        return bl;
    }

    protected boolean checkPost() {
        boolean bl = true;
        if (this.action != null) {
            bl &= this.checkParams(this.action.pattern.getParamDecls(), this.params.getChildren());
            bl &= this.checkReturns(this.action.returnFormalParameters.getChildren(), this.returns);
        } else if (this.sequence != null) {
            Vector vector = new Vector();
            for (ExecVarDeclNode execVarDeclNode : this.sequence.outParams.getChildren()) {
                vector.add(execVarDeclNode.getDeclType());
            }
            bl &= this.checkParams(this.sequence.inParams.getChildren(), this.params.getChildren());
            bl &= this.checkReturns(vector, this.returns);
        }
        if (this.action != null) {
            for (FilterFunctionDeclNode filterFunctionDeclNode : this.filterFunctions.getChildren()) {
                if (filterFunctionDeclNode.action == this.action) continue;
                this.reportError("The filter " + filterFunctionDeclNode.toStringWithDeclarationCoords() + " is defined for the action " + filterFunctionDeclNode.action.toStringWithDeclarationCoords() + ". It cannot be applied to the action " + this.action.toStringWithDeclarationCoords() + ".");
            }
        } else if (this.filterFunctionsUnresolved.size() > 0) {
            this.reportError("Match filters can only be applied to tests or rules (but not to " + this.actionUnresolved + ").");
        }
        return bl;
    }

    private boolean checkParams(Collection<? extends DeclNode> collection, Collection<? extends ExprNode> collection2) {
        if (collection.size() != collection2.size()) {
            this.reportError("The " + (this.action != null ? this.action.getKind() + " " + this.action.toStringWithDeclarationCoords() : this.sequence.getKind() + " " + this.sequence.toStringWithDeclarationCoords()) + " expects " + collection.size() + " arguments, but is given " + collection2.size() + " arguments.");
            return false;
        }
        boolean bl = true;
        if (collection2.size() > 0) {
            Iterator<? extends ExprNode> iterator = collection2.iterator();
            int n = 1;
            for (DeclNode declNode : collection) {
                ExprNode exprNode = iterator.next();
                bl &= this.checkParam(n, declNode, exprNode);
                ++n;
            }
        }
        return bl;
    }

    private boolean checkParam(int n, DeclNode declNode, ExprNode exprNode) {
        TypeNode typeNode;
        BaseNode baseNode;
        if (declNode instanceof EdgeInterfaceTypeChangeDeclNode) {
            baseNode = (EdgeInterfaceTypeChangeDeclNode)declNode;
            typeNode = ((EdgeInterfaceTypeChangeDeclNode)baseNode).interfaceType.getDeclType();
        } else if (declNode instanceof NodeInterfaceTypeChangeDeclNode) {
            baseNode = (NodeInterfaceTypeChangeDeclNode)declNode;
            typeNode = ((NodeInterfaceTypeChangeDeclNode)baseNode).interfaceType.getDeclType();
        } else {
            typeNode = declNode.getDecl().getDeclType();
        }
        baseNode = exprNode.getType();
        if (baseNode instanceof UntypedExecVarTypeNode) {
            return true;
        }
        if (baseNode instanceof TypeTypeNode && (typeNode instanceof NodeTypeNode || typeNode instanceof EdgeTypeNode)) {
            return true;
        }
        if (!((TypeNode)baseNode).isCompatibleTo(typeNode)) {
            String string = this.action != null ? this.action.getKind() + " " + this.action.toStringWithDeclarationCoords() : this.sequence.getKind() + " " + this.sequence.toStringWithDeclarationCoords();
            this.reportError("Cannot convert " + n + ". argument from " + ((TypeNode)baseNode).getTypeName() + " to the expected " + typeNode.getTypeName() + " (when calling " + string + ")" + baseNode.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + typeNode.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + ".");
            return false;
        }
        return true;
    }

    private boolean checkReturns(Collection<? extends TypeNode> collection, CollectNode<ExecVarDeclNode> collectNode) {
        if (collectNode.size() > 0 && collection.size() != collectNode.size()) {
            this.reportError("The " + (this.action != null ? this.action.getKind() + " " + this.action.toStringWithDeclarationCoords() : this.sequence.getKind() + " " + this.sequence.toStringWithDeclarationCoords()) + " expects " + collection.size() + " return arguments, but is given " + collectNode.size() + " return arguments.");
            return false;
        }
        boolean bl = true;
        if (collectNode.size() > 0) {
            Iterator<ExecVarDeclNode> iterator = collectNode.getChildren().iterator();
            int n = 0;
            for (TypeNode typeNode : collection) {
                ExecVarDeclNode execVarDeclNode = iterator.next();
                bl &= this.checkReturn(typeNode, execVarDeclNode, n);
                ++n;
            }
        }
        return bl;
    }

    private boolean checkReturn(TypeNode typeNode, ExecVarDeclNode execVarDeclNode, int n) {
        Object object;
        TypeNode typeNode2 = typeNode;
        TypeNode typeNode3 = execVarDeclNode.getDecl().getDeclType();
        if (typeNode3 instanceof UntypedExecVarTypeNode) {
            return true;
        }
        boolean bl = false;
        if (this.isAllBracketed) {
            if (!(typeNode3 instanceof ArrayTypeNode)) {
                bl = true;
            } else {
                object = (ArrayTypeNode)typeNode3;
                if (!typeNode2.isCompatibleTo(((ArrayTypeNode)object).valueType)) {
                    bl = true;
                }
            }
        } else if (!typeNode2.isCompatibleTo(typeNode3)) {
            bl = true;
        }
        if (bl) {
            object = this.action != null ? this.action.getKind() + " " + this.action.toStringWithDeclarationCoords() : this.sequence.getKind() + " " + this.sequence.toStringWithDeclarationCoords();
            this.reportError("Cannot assign " + (n + 1) + ". return argument of type " + typeNode2.getTypeName() + (this.isAllBracketed ? " (array<" + typeNode2.getTypeName() + ">)" : "") + " to a variable " + execVarDeclNode + " of type " + typeNode3.getTypeName() + " (when calling " + (String)object + ")" + typeNode2.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + typeNode3.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + ".");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        assert (false);
        return Bad.getBad();
    }

    static {
        CallActionNode.setName(CallActionNode.class, "call action");
        actionResolver = new DeclarationTripleResolver<ActionDeclNode, SequenceDeclNode, ExecVarDeclNode>(ActionDeclNode.class, SequenceDeclNode.class, ExecVarDeclNode.class);
        paramNodeResolver = new CollectResolver<ExprNode>(new DeclarationResolver<ExprNode>(ExprNode.class));
        varDeclNodeResolver = new CollectResolver<ExecVarDeclNode>(new DeclarationResolver<ExecVarDeclNode>(ExecVarDeclNode.class));
        filterResolver = new CollectResolver<FilterFunctionDeclNode>(new DeclarationResolver<FilterFunctionDeclNode>(FilterFunctionDeclNode.class));
    }
}

