/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast;

import de.unika.ipd.grgen.ast.AmbiguousIdentNode;
import de.unika.ipd.grgen.ast.ErrorNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.UnitNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.model.decl.ModelNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphBaseNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeActionNode;
import de.unika.ipd.grgen.ast.type.MatchTypeIteratedNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.parser.Scope;
import de.unika.ipd.grgen.parser.Symbol;
import de.unika.ipd.grgen.util.Base;
import de.unika.ipd.grgen.util.GraphDumpable;
import de.unika.ipd.grgen.util.Walkable;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class BaseNode
extends Base
implements GraphDumpable,
Walkable {
    public static final int CONTEXT_LHS_OR_RHS = 1;
    public static final int CONTEXT_LHS = 0;
    public static final int CONTEXT_RHS = 1;
    public static final int CONTEXT_ACTION_OR_PATTERN = 2;
    public static final int CONTEXT_ACTION = 0;
    public static final int CONTEXT_PATTERN = 2;
    public static final int CONTEXT_TEST_OR_RULE = 4;
    public static final int CONTEXT_TEST = 0;
    public static final int CONTEXT_RULE = 4;
    public static final int CONTEXT_NEGATIVE = 8;
    public static final int CONTEXT_INDEPENDENT = 16;
    public static final int CONTEXT_PARAMETER = 32;
    public static final int CONTEXT_COMPUTATION = 64;
    public static final int CONTEXT_FUNCTION_OR_PROCEDURE = 128;
    public static final int CONTEXT_FUNCTION = 0;
    public static final int CONTEXT_PROCEDURE = 128;
    public static final int CONTEXT_METHOD = 256;
    private static final Map<Class<? extends BaseNode>, String> names = new HashMap<Class<? extends BaseNode>, String>();
    private static final BaseNode NULL = new ErrorNode();
    private static boolean verboseErrorMsg = true;
    private Coords coords = Coords.getInvalid();
    private static Scope currScope = Scope.getInvalid();
    private Scope scope;
    protected Set<BaseNode> parents = new LinkedHashSet<BaseNode>();
    private boolean resolved = false;
    private boolean resolveResult = false;
    private boolean checkVisited = false;
    private boolean checked = false;
    private boolean checkResult = false;
    private IR irObject = null;

    protected BaseNode(Coords coords) {
        this();
        this.coords = coords;
    }

    protected BaseNode() {
        this.scope = currScope;
    }

    public String toString() {
        return this.getName();
    }

    protected static String shortClassName(Class<?> clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String getName(Class<? extends BaseNode> clazz) {
        return names.containsKey(clazz) ? names.get(clazz) : "<" + BaseNode.shortClassName(clazz) + ">";
    }

    protected static void setName(Class<? extends BaseNode> clazz, String string) {
        names.put(clazz, string);
    }

    public String getName() {
        Class<?> clazz = this.getClass();
        String string = BaseNode.getName(clazz);
        if (verboseErrorMsg) {
            string = string + " <" + this.getId() + "," + BaseNode.shortClassName(clazz) + ">";
        }
        return string;
    }

    protected final void setName(String string) {
        names.put(this.getClass(), string);
    }

    public final String getKind() {
        String string;
        block2: {
            string = "<unknown>";
            try {
                string = (String)this.getClass().getMethod("getKindStr", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)exception.toString());
            }
        }
        return string;
    }

    public static String getKindStr() {
        return "base node";
    }

    public static BaseNode getErrorNode() {
        return NULL;
    }

    protected String extraNodeInfo() {
        return null;
    }

    public static void setVerbose(boolean bl) {
        verboseErrorMsg = bl;
    }

    public boolean isError() {
        return false;
    }

    public final void reportError(String string) {
        error.error(this.getCoords(), string);
    }

    public final void reportWarning(String string) {
        error.warning(this.getCoords(), string);
    }

    public final Coords getCoords() {
        return this.coords;
    }

    public final void setCoords(Coords coords) {
        this.coords = coords;
    }

    public final String getAtCoords() {
        return this.coords.getAtCoords();
    }

    public final String getDeclarationCoords() {
        return this.coords.getDeclarationCoords(false);
    }

    public final String toStringWithDeclarationCoords() {
        boolean bl;
        boolean bl2 = bl = this instanceof MatchTypeActionNode || this instanceof MatchTypeIteratedNode;
        if (this instanceof DeclaredTypeNode) {
            DeclNode declNode = ((DeclaredTypeNode)this).getDecl();
            return this.userFriendlyToString() + (declNode != null ? declNode.getCoords().getDeclarationCoords(bl) : "");
        }
        return this.userFriendlyToString() + this.coords.getDeclarationCoords(bl);
    }

    public final String toStringWithDeclarationCoordsIfCoordsAreOfInterest() {
        boolean bl;
        boolean bl2 = bl = this instanceof MatchTypeActionNode || this instanceof MatchTypeIteratedNode;
        if (this instanceof DeclaredTypeNode) {
            DeclNode declNode = ((DeclaredTypeNode)this).getDecl();
            if (declNode == null || declNode.getCoords().getDeclarationCoords(bl) == "") {
                return "";
            }
            return " (" + this.userFriendlyToString() + " is" + (declNode != null ? declNode.getCoords().getDeclarationCoords(bl) : "") + ")";
        }
        if (this.coords.getDeclarationCoords(bl) == "") {
            return "";
        }
        return " (" + this.userFriendlyToString() + " is" + this.coords.getDeclarationCoords(bl) + ")";
    }

    public final String userFriendlyToString() {
        if (this instanceof PatternGraphBaseNode) {
            return ((PatternGraphBaseNode)this).nameOfGraph;
        }
        if (this instanceof TypeNode) {
            return ((TypeNode)this).getTypeName();
        }
        if (this instanceof DeclNode) {
            return ((DeclNode)this).dotOrArrowWhenAnonymous();
        }
        return this.toString();
    }

    public final Scope getScope() {
        return this.scope;
    }

    public static void setCurrScope(Scope scope) {
        currScope = scope;
    }

    public abstract Collection<? extends BaseNode> getChildren();

    protected abstract Collection<String> getChildrenNames();

    @Override
    public Collection<? extends BaseNode> getWalkableChildren() {
        return this.getChildren();
    }

    public final void switchParenthood(BaseNode baseNode, BaseNode baseNode2) {
        baseNode.parents.remove(this);
        baseNode2.parents.add(this);
    }

    public final <T extends BaseNode> T becomeParent(T t) {
        if (t != null) {
            t.parents.add(this);
        }
        return t;
    }

    protected final <T extends BaseNode> T ownedResolutionResult(T t, T t2) {
        if (t2 != null && t2 != t) {
            this.becomeParent(t2);
            return t2;
        }
        return t;
    }

    protected final <T extends BaseNode> T getValidResolvedVersion(T t, T t2) {
        assert (this.isResolved()) : this;
        if (t != null) {
            return t;
        }
        if (t2 != null) {
            return t2;
        }
        assert (false) : this;
        return null;
    }

    protected final <T extends BaseNode> T getValidResolvedVersion(T t, T t2, T t3) {
        assert (this.isResolved()) : this;
        if (t != null) {
            return t;
        }
        if (t2 != null) {
            return t2;
        }
        if (t3 != null) {
            return t3;
        }
        assert (false) : this;
        return null;
    }

    protected final <T extends BaseNode> T getValidVersion(T t, T t2) {
        if (this.isResolved()) {
            return t2;
        }
        return t;
    }

    protected final <T extends BaseNode> T getValidVersion(T t, T t2, T t3) {
        if (this.isResolved()) {
            if (t2 != null) {
                return t2;
            }
            if (t3 != null) {
                return t3;
            }
        }
        return t;
    }

    protected final <T extends BaseNode> T getValidVersion(T t, T t2, T t3, T t4) {
        if (this.isResolved()) {
            if (t2 != null) {
                return t2;
            }
            if (t3 != null) {
                return t3;
            }
            if (t4 != null) {
                return t4;
            }
        }
        return t;
    }

    protected final <T extends BaseNode> T getValidVersion(T t, T t2, T t3, T t4, T t5) {
        if (this.isResolved()) {
            if (t2 != null) {
                return t2;
            }
            if (t3 != null) {
                return t3;
            }
            if (t4 != null) {
                return t4;
            }
            if (t5 != null) {
                return t5;
            }
        }
        return t;
    }

    protected final <T extends BaseNode> Vector<T> getValidVersionVector(Vector<? extends T> vector, Vector<? extends T> vector2) {
        Vector<BaseNode> vector3 = new Vector<BaseNode>();
        if (this.isResolved()) {
            for (int i = 0; i < vector2.size(); ++i) {
                vector3.add((BaseNode)vector2.get(i));
            }
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                vector3.add((BaseNode)vector.get(i));
            }
        }
        return vector3;
    }

    protected final <T extends BaseNode> Vector<T> getValidVersionVector(Vector<? extends T> vector, Vector<? extends T> vector2, Vector<? extends T> vector3) {
        Vector<BaseNode> vector4 = new Vector<BaseNode>();
        if (this.isResolved()) {
            if (!vector2.isEmpty()) {
                for (int i = 0; i < vector2.size(); ++i) {
                    vector4.add((BaseNode)vector2.get(i));
                }
            } else {
                for (int i = 0; i < vector3.size(); ++i) {
                    vector4.add((BaseNode)vector3.get(i));
                }
            }
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                vector4.add((BaseNode)vector.get(i));
            }
        }
        return vector4;
    }

    public final boolean isRoot() {
        return this.parents.isEmpty();
    }

    public final Collection<BaseNode> getParents() {
        return Collections.unmodifiableCollection(this.parents);
    }

    public static final boolean manifestAST(UnitNode unitNode) {
        UnitNode.setRoot(unitNode);
        boolean bl = unitNode.resolve();
        if (bl) {
            return unitNode.check();
        }
        return false;
    }

    public final boolean resolve() {
        if (this.isResolved()) {
            return this.resolutionResult();
        }
        debug.report(4, this.getCoords(), "resolve in: " + this.getId() + "(" + this.getClass() + ")");
        boolean bl = this.resolveLocal();
        this.nodeResolvedSetResult(bl);
        if (!bl) {
            debug.report(4, this.getCoords(), "local resolve ERROR in " + this);
        }
        for (BaseNode baseNode : this.getChildren()) {
            boolean bl2 = baseNode != null && baseNode.resolve();
            bl &= bl2;
        }
        if (!bl) {
            debug.report(4, this.getCoords(), "child resolve ERROR in " + this);
        }
        return bl;
    }

    protected abstract boolean resolveLocal();

    private void nodeResolvedSetResult(boolean bl) {
        this.resolved = true;
        this.resolveResult = bl;
    }

    public final boolean isResolved() {
        return this.resolved;
    }

    public final boolean resolutionResult() {
        assert (this.isResolved()) : this;
        return this.resolveResult;
    }

    public final boolean check() {
        debug.report(4, this.getCoords(), "check in: " + this.getId() + "(" + this.getClass() + ")");
        if (!this.resolutionResult()) {
            return false;
        }
        if (this.isChecked()) {
            return this.getChecked();
        }
        boolean bl = true;
        if (!this.visitedDuringCheck()) {
            this.setCheckVisited();
            for (BaseNode baseNode : this.getChildren()) {
                boolean bl2 = baseNode.check();
                bl &= bl2;
            }
        }
        if (!bl) {
            debug.report(4, this.getCoords(), "child check ERROR in " + this);
        }
        boolean bl3 = this.checkLocal();
        this.nodeCheckedSetResult(bl3);
        if (!bl3) {
            debug.report(4, this.getCoords(), "local check ERROR in " + this);
        }
        return bl && bl3;
    }

    protected abstract boolean checkLocal();

    protected final void nodeCheckedSetResult(boolean bl) {
        this.checked = true;
        this.checkResult = bl;
    }

    public final boolean isChecked() {
        return this.checked;
    }

    protected final boolean getChecked() {
        assert (this.isChecked()) : this;
        return this.checkResult;
    }

    protected final void setCheckVisited() {
        this.checkVisited = true;
    }

    protected final boolean visitedDuringCheck() {
        return this.checkVisited;
    }

    public static boolean fixupDefinition(BaseNode baseNode, Scope scope) {
        if (!(baseNode instanceof IdentNode)) {
            return true;
        }
        return BaseNode.fixupDefinition((IdentNode)baseNode, scope);
    }

    public static boolean fixupDefinition(IdentNode identNode, Scope scope) {
        debug.report(4, "Fixup " + identNode + " in scope " + scope);
        Symbol.Definition definition = scope.getCurrDef(identNode.getSymbol());
        debug.report(4, "definition is: " + definition);
        boolean bl = definition.isValid();
        if (!bl && identNode instanceof AmbiguousIdentNode) {
            AmbiguousIdentNode ambiguousIdentNode = (AmbiguousIdentNode)identNode;
            definition = scope.getCurrDef(ambiguousIdentNode.getOtherSymbol());
            debug.report(4, "definition now is: " + definition);
            bl = definition.isValid();
        }
        if (bl) {
            identNode.setSymDef(definition);
        } else {
            identNode.reportError("The identifier " + identNode + " has not been declared in this scope: " + scope.toStringWithOpeningCoords() + ".");
        }
        return bl;
    }

    public static boolean tryFixupDefinition(BaseNode baseNode, Scope scope) {
        if (!(baseNode instanceof IdentNode)) {
            return false;
        }
        IdentNode identNode = (IdentNode)baseNode;
        debug.report(4, "try Fixup " + identNode + " in scope " + scope);
        Symbol.Definition definition = scope.getCurrDef(identNode.getSymbol());
        debug.report(4, "definition is: " + definition);
        if (definition.isValid()) {
            identNode.setSymDef(definition);
            return true;
        }
        return false;
    }

    protected static boolean fixupDefinition(IdentNode identNode, Scope scope, boolean bl) {
        debug.report(4, "Fixup " + identNode + " in scope " + scope);
        Symbol.Definition definition = scope.getLocalDef(identNode.getSymbol());
        debug.report(4, "definition is: " + definition);
        boolean bl2 = definition.isValid();
        if (bl2) {
            identNode.setSymDef(definition);
        } else if (bl) {
            identNode.reportError("The identifier " + identNode + " has not been declared in this scope: " + scope.toStringWithOpeningCoords() + ".");
        }
        return bl2;
    }

    public final IR getIR() {
        if (this.irObject == null) {
            this.setIR(this.constructIR());
        }
        return this.irObject;
    }

    protected final void setIR(IR iR) {
        if (this.irObject == null) {
            this.irObject = iR;
            return;
        }
        if (this.irObject != iR) assert (false) : "Another IR object already exists.";
    }

    protected final boolean isIRAlreadySet() {
        return this.irObject != null;
    }

    public final <T extends IR> T checkIR(Class<T> clazz) {
        IR iR = this.getIR();
        debug.report(4, this.getCoords(), "checking ir object in \"" + this.getName() + "\" should be \"" + clazz + "\" is \"" + iR.getClass() + "\"");
        assert (clazz.isInstance(iR)) : "checking ir object in \"" + this.getName() + "\" should be \"" + clazz + "\" is \"" + iR.getClass() + "\"";
        return (T)((IR)clazz.cast(iR));
    }

    protected IR constructIR() {
        return IR.getBad();
    }

    @Override
    public Color getNodeColor() {
        return Color.WHITE;
    }

    @Override
    public final String getNodeId() {
        return this.getId();
    }

    @Override
    public String getNodeInfo() {
        String string = this.extraNodeInfo();
        return "ID: " + this.getId() + (string != null ? "\n" + string : "");
    }

    @Override
    public String getNodeLabel() {
        return this.getName();
    }

    @Override
    public int getNodeShape() {
        return -1;
    }

    @Override
    public final String getEdgeLabel(int n) {
        Collection<String> collection = this.getChildrenNames();
        int n2 = -1;
        for (String string : collection) {
            if (++n2 != n) continue;
            return string;
        }
        return "" + n;
    }

    private TypeDeclNode findType(String string) {
        BaseNode baseNode = this;
        while (!baseNode.isRoot()) {
            baseNode = baseNode.getParents().iterator().next();
        }
        TypeDeclNode typeDeclNode = null;
        ModelNode modelNode = ((UnitNode)baseNode).getStdModel();
        assert (modelNode.isResolved());
        Collection<TypeDeclNode> collection = modelNode.decls.getChildren();
        for (TypeDeclNode typeDeclNode2 : collection) {
            String string2 = typeDeclNode2.ident.getSymbol().getText();
            if (!string2.equals(string)) continue;
            typeDeclNode = typeDeclNode2;
        }
        return typeDeclNode;
    }

    public final TypeDeclNode getNodeRootTypeDecl() {
        return this.findType("Node");
    }

    public final TypeDeclNode getArbitraryEdgeRootTypeDecl() {
        return this.findType("AEdge");
    }

    public final TypeDeclNode getDirectedEdgeRootTypeDecl() {
        return this.findType("Edge");
    }

    public final TypeDeclNode getUndirectedEdgeRootTypeDecl() {
        return this.findType("UEdge");
    }
}

