/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen;

import de.unika.ipd.grgen.Sys;
import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.UnitNode;
import de.unika.ipd.grgen.ast.model.decl.ModelNode;
import de.unika.ipd.grgen.be.Backend;
import de.unika.ipd.grgen.be.BackendFactory;
import de.unika.ipd.grgen.ir.Dumper;
import de.unika.ipd.grgen.ir.Unit;
import de.unika.ipd.grgen.parser.antlr.GRParserEnvironment;
import de.unika.ipd.grgen.util.Base;
import de.unika.ipd.grgen.util.GraphDumpVisitor;
import de.unika.ipd.grgen.util.NullOutputStream;
import de.unika.ipd.grgen.util.PostWalker;
import de.unika.ipd.grgen.util.VCGDumper;
import de.unika.ipd.grgen.util.VCGDumperFactory;
import de.unika.ipd.grgen.util.Walkable;
import de.unika.ipd.grgen.util.XMLDumper;
import de.unika.ipd.grgen.util.report.DebugReporter;
import de.unika.ipd.grgen.util.report.ErrorReporter;
import de.unika.ipd.grgen.util.report.Handler;
import de.unika.ipd.grgen.util.report.NullReporter;
import de.unika.ipd.grgen.util.report.Reporter;
import de.unika.ipd.grgen.util.report.StreamHandler;
import de.unika.ipd.grgen.util.report.TableHandler;
import jargs.gnu.CmdLineParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;

public class Main
extends Base
implements Sys {
    private String[] args;
    private String[] inputFileNames;
    private UnitNode root;
    private Unit irUnit;
    private ErrorReporter errorReporter;
    private Reporter debugReporter;
    private Handler debugHandler;
    private boolean noEvents;
    private boolean noDebugEvents;
    private boolean enableDebug;
    private boolean emitProfiling;
    private boolean dumpAST;
    private boolean dumpIR;
    private boolean dumpRules;
    private boolean printTiming;
    private String debugFilter;
    private String invDebugFilter;
    private String dumpOutputToFile;
    private String backend;
    private boolean graphic;
    private JPanel debugPanel;
    private JTree debugTree;
    private Preferences prefs;
    private String prefsExport;
    private String prefsImport;
    private File outputPath = new File(".");
    private File sourcePath;
    private File debugPath;
    private File modelPath = null;

    @Override
    public File getModelPath() {
        return this.modelPath;
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    private static void printUsage() {
        System.out.println("usage: grgen [options] filenames");
        System.out.println("filenames may consist of one .grg and multiple .gm files");
        System.out.println("Options are:");
        System.out.println("  -t, --timing                      print some timing stats");
        System.out.println("  -d, --debug                       enable debugging");
        System.out.println("  -r  --profile                     emit profiling instrumentation");
        System.out.println("  -a, --dump-ast                    dump the AST");
        System.out.println("  -i, --dump-ir                     dump the intermidiate representation");
        System.out.println("  -j, --dump-ir-rules               dump each ir rule in a seperate file");
        System.out.println("  -g, --graphic                     opens a graphical debug window");
        System.out.println("  -b, --backend=BE                  select backend BE");
        System.out.println("  -f, --debug-filter=REGEX          only debug messages matching this filter will be displayd");
        System.out.println("  -F, --inverse-debug-filter=REGEX  only debug messages not matching this filter will be displayd");
        System.out.println("  -p, --prefs=FILE                  import preferences from FILE");
        System.out.println("  -x, --prefs-export=FILE           export preferences to FILE");
        System.out.println("  -o, --output=DIRECTORY            write generated files to DIRECTORY");
        System.out.println("  -v, --noactionevents              the generated code may not fire action events");
        System.out.println("  -e, --noattributeevents           the generated code may not fire attribute change events");
    }

    private static JPanel getTablePanel(TableHandler tableHandler) {
        JTable jTable = new JTable(tableHandler);
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.setLayout(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(800, 600));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JFrame makeMainFrame() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (this.debugPanel != null) {
            jPanel.add(this.debugPanel);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        JButton jButton = new JButton("Expand All");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < Main.this.debugTree.getRowCount(); ++i) {
                    Main.this.debugTree.expandRow(i);
                }
            }
        });
        JButton jButton2 = new JButton("Exit");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        JFrame jFrame = new JFrame("GrGen");
        jFrame.setContentPane(jPanel);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = jFrame.getBounds();
        jFrame.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        jFrame.setVisible(true);
        return jFrame;
    }

    private void init() {
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        if (this.enableDebug) {
            if (this.graphic) {
                this.debugHandler = new TableHandler();
                this.debugPanel = Main.getTablePanel((TableHandler)this.debugHandler);
            } else {
                this.debugHandler = new StreamHandler(System.out);
            }
            DebugReporter debugReporter = new DebugReporter(15);
            debugReporter.addHandler(this.debugHandler);
            if (this.debugFilter != null) {
                debugReporter.setFilter(this.debugFilter);
            }
            if (this.invDebugFilter != null) {
                debugReporter.setFilter(this.invDebugFilter);
                debugReporter.setFilterInclusive(false);
            }
            this.debugReporter = debugReporter;
        } else {
            this.debugReporter = new NullReporter();
        }
        this.errorReporter = new ErrorReporter();
        this.errorReporter.addHandler(new StreamHandler(System.err));
        Base.setReporters(this.debugReporter, this.errorReporter);
    }

    private void parseOptions() {
        try {
            Object object;
            CmdLineParser cmdLineParser = new CmdLineParser();
            CmdLineParser.Option option = cmdLineParser.addBooleanOption('d', "debug");
            CmdLineParser.Option option2 = cmdLineParser.addBooleanOption('r', "profile");
            CmdLineParser.Option option3 = cmdLineParser.addBooleanOption('a', "dump-ast");
            CmdLineParser.Option option4 = cmdLineParser.addBooleanOption('i', "dump-ir");
            CmdLineParser.Option option5 = cmdLineParser.addBooleanOption('j', "dump-ir-rules");
            CmdLineParser.Option option6 = cmdLineParser.addBooleanOption('g', "graphic");
            CmdLineParser.Option option7 = cmdLineParser.addBooleanOption('t', "timing");
            CmdLineParser.Option option8 = cmdLineParser.addBooleanOption('e', "noevents");
            CmdLineParser.Option option9 = cmdLineParser.addBooleanOption('v', "nodebugevents");
            CmdLineParser.Option option10 = cmdLineParser.addStringOption('c', "dump-output-to-file");
            CmdLineParser.Option option11 = cmdLineParser.addStringOption('b', "backend");
            CmdLineParser.Option option12 = cmdLineParser.addStringOption('f', "debug-filter");
            CmdLineParser.Option option13 = cmdLineParser.addStringOption('F', "inverse-debug-filter");
            CmdLineParser.Option option14 = cmdLineParser.addStringOption('p', "prefs");
            CmdLineParser.Option option15 = cmdLineParser.addStringOption('x', "prefs-export");
            CmdLineParser.Option option16 = cmdLineParser.addStringOption('o', "output");
            cmdLineParser.parse(this.args);
            this.dumpOutputToFile = (String)cmdLineParser.getOptionValue(option10);
            if (this.dumpOutputToFile != null) {
                try {
                    object = new PrintStream(new FileOutputStream(this.dumpOutputToFile));
                    System.setErr((PrintStream)object);
                    System.setOut((PrintStream)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
            this.dumpAST = cmdLineParser.getOptionValue(option3) != null;
            this.dumpIR = cmdLineParser.getOptionValue(option4) != null;
            this.dumpRules = cmdLineParser.getOptionValue(option5) != null;
            this.enableDebug = cmdLineParser.getOptionValue(option) != null;
            this.emitProfiling = cmdLineParser.getOptionValue(option2) != null;
            this.graphic = cmdLineParser.getOptionValue(option6) != null;
            this.printTiming = cmdLineParser.getOptionValue(option7) != null;
            this.noEvents = cmdLineParser.getOptionValue(option8) != null;
            boolean bl = this.noDebugEvents = cmdLineParser.getOptionValue(option9) != null;
            if (!this.enableDebug) {
                this.graphic = false;
            }
            this.debugFilter = (String)cmdLineParser.getOptionValue(option12);
            this.invDebugFilter = (String)cmdLineParser.getOptionValue(option13);
            this.backend = (String)cmdLineParser.getOptionValue(option11);
            object = (String)cmdLineParser.getOptionValue(option16);
            this.outputPath = new File((String)(object != null ? object : System.getProperty("user.dir")));
            this.prefsImport = (String)cmdLineParser.getOptionValue(option14);
            this.prefsExport = (String)cmdLineParser.getOptionValue(option15);
            this.inputFileNames = cmdLineParser.getRemainingArgs();
            if (this.inputFileNames.length == 0) {
                Main.printUsage();
                System.exit(2);
            }
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            Main.printUsage();
            System.exit(2);
        }
    }

    @Override
    public boolean mayFireEvents() {
        return !this.noEvents;
    }

    @Override
    public boolean mayFireDebugEvents() {
        return !this.noDebugEvents && !this.noEvents;
    }

    @Override
    public boolean emitProfilingInstrumentation() {
        return this.emitProfiling;
    }

    @Override
    public OutputStream createDebugFile(File file) {
        this.debugPath.mkdirs();
        File file2 = new File(this.debugPath, file.getName());
        try {
            return new BufferedOutputStream(new FileOutputStream(file2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorReporter.error("Cannot open debug file " + file2.getPath() + ".");
            return NullOutputStream.STREAM;
        }
    }

    private boolean parseInput() {
        Object object;
        File file;
        boolean bl = false;
        boolean bl2 = true;
        GRParserEnvironment gRParserEnvironment = new GRParserEnvironment(this);
        for (String string : this.inputFileNames) {
            file = new File(string);
            object = Main.getFileExt(string);
            if (((String)object).equals("grg")) {
                if (this.root != null) {
                    error.error("Only one .grg file may be specified.");
                    System.exit(-1);
                }
                this.initPaths(string, file, bl2);
                bl2 = false;
                this.root = gRParserEnvironment.parseActions(file);
                continue;
            }
            if (((String)object).equals("gm")) continue;
            error.error("Input file with unknown extension: \"" + (String)object + "\".");
            System.exit(-1);
        }
        if (this.root == null) {
            this.root = new UnitNode("NoGRGFileGiven", this.inputFileNames[0], gRParserEnvironment.getStdModel(), new CollectNode<ModelNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>(), new CollectNode<IdentNode>());
        }
        for (String string : this.inputFileNames) {
            file = new File(string);
            if (!Main.getFileExt(string).equals("gm")) continue;
            this.initPaths(string, file, bl2);
            bl2 = false;
            object = gRParserEnvironment.parseModel(file);
            this.root.addModel((ModelNode)object);
        }
        bl = !gRParserEnvironment.hadError();
        gRParserEnvironment.getCurrScope().leaveScope();
        debug.report(4, "result: " + bl);
        return bl;
    }

    private static String getFileExt(String string) {
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n == -1 || n2 != -1 && n < n2) {
            error.error("The input file \"" + string + "\" is lacking the name extension.");
            System.exit(-1);
        }
        return string.substring(n + 1).toLowerCase();
    }

    private void initPaths(String string, File file, boolean bl) {
        this.sourcePath = string.indexOf(47) != -1 || string.indexOf(92) != -1 ? file.getAbsoluteFile().getParentFile() : new File(".");
        if (bl) {
            this.debugPath = new File(this.sourcePath, file.getName() + "_debug");
        }
        this.modelPath = this.sourcePath;
    }

    private void dumpVCG(Walkable walkable, GraphDumpVisitor graphDumpVisitor, String string) {
        File file = new File(string + ".vcg");
        try (OutputStream outputStream = this.createDebugFile(file);
             PrintStream printStream = new PrintStream(outputStream);){
            VCGDumper vCGDumper = new VCGDumper(printStream);
            graphDumpVisitor.setDumper(vCGDumper);
            PostWalker postWalker = new PostWalker(graphDumpVisitor);
            vCGDumper.begin();
            postWalker.reset();
            postWalker.walk(walkable);
            vCGDumper.finish();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void buildIR() {
        this.irUnit = this.root.getUnit();
    }

    private void generateCode() {
        assert (this.backend != null) : "backend must be set to generate code.";
        try {
            BackendFactory backendFactory = (BackendFactory)Class.forName(this.backend).newInstance();
            Backend backend = backendFactory.getBackend();
            backend.init(this.irUnit, this, this.outputPath);
            backend.generate();
            backend.done();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("cannot locate backend class: " + this.backend);
            System.exit(-1);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("no rights to create backend class: " + this.backend);
            System.exit(-1);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("cannot create backend class: " + this.backend);
            System.exit(-1);
        }
        catch (Throwable throwable) {
            System.err.println("unexpected exception occurred:");
            throwable.printStackTrace();
            System.exit(-1);
        }
        if (ErrorReporter.getErrorCount() > 0) {
            if (ErrorReporter.getErrorCount() == 1) {
                System.err.println("There was " + ErrorReporter.getErrorCount() + " error");
            } else {
                System.err.println("There were " + ErrorReporter.getErrorCount() + " errors");
            }
            System.exit(-1);
        } else if (ErrorReporter.getWarnCount() > 0) {
            if (ErrorReporter.getWarnCount() == 1) {
                System.err.println("There was " + ErrorReporter.getWarnCount() + " warning");
            } else {
                System.err.println("There were " + ErrorReporter.getWarnCount() + " warnings");
            }
        }
    }

    private void run() {
        long l = -System.currentTimeMillis();
        this.parseOptions();
        this.init();
        this.importPrefs();
        if (this.graphic) {
            this.makeMainFrame();
        }
        debug.report(4, "working directory: " + System.getProperty("user.dir"));
        l += System.currentTimeMillis();
        long l2 = -System.currentTimeMillis();
        debug.report(4, "### Parse Input ###");
        if (!this.parseInput()) {
            debug.report(4, "### ERROR in Parse Input. Exiting! ###");
            System.exit(1);
        }
        l2 += System.currentTimeMillis();
        long l3 = -System.currentTimeMillis();
        debug.report(4, "### Manifest AST ###");
        if (!BaseNode.manifestAST(this.root)) {
            if (this.dumpAST) {
                this.dumpVCG(this.root, new GraphDumpVisitor(), "error-ast");
            }
            debug.report(4, "### ERROR in Manifest AST. Exiting! ###");
            if (ErrorReporter.getErrorCount() == 0) {
                error.error("An unknown error occurred in \"Manifest AST\".");
            }
            System.exit(1);
        }
        l3 += System.currentTimeMillis();
        if (this.dumpAST) {
            this.dumpVCG(this.root, new GraphDumpVisitor(), "ast");
        }
        debug.report(4, "### Build IR ###");
        long l4 = -System.currentTimeMillis();
        this.buildIR();
        this.root = null;
        this.irUnit.postPatchIR();
        this.irUnit.checkForEmptyPatternsInIterateds();
        this.irUnit.checkForEmptySubpatternRecursions();
        this.irUnit.checkForNeverSucceedingSubpatternRecursions();
        this.irUnit.checkForMultipleRetypes();
        this.irUnit.checkForMultipleDeletesOrRetypes();
        this.irUnit.transmitExecUsageToRules();
        this.irUnit.setDependencyLevelOfInterElementDependencies();
        this.irUnit.resolvePatternLockedModifier();
        this.irUnit.ensureDirectlyNestingPatternContainsAllNonLocalElementsOfNestedPattern();
        this.irUnit.checkForRhsElementsUsedOnLhs();
        this.irUnit.checkForParallelizedModelIfParallelizedActionExists();
        l4 += System.currentTimeMillis();
        VCGDumperFactory vCGDumperFactory = new VCGDumperFactory(this);
        Dumper dumper = new Dumper(vCGDumperFactory, true);
        if (this.dumpIR) {
            dumper.dumpComplete(this.irUnit, "ir");
            if (this.dumpRules) {
                dumper.dump(this.irUnit);
            }
            try (OutputStream outputStream = this.createDebugFile(new File("ir.xml"));
                 PrintStream printStream = new PrintStream(outputStream);){
                XMLDumper xMLDumper = new XMLDumper(printStream);
                xMLDumper.dump(this.irUnit);
                printStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.graphic && this.debugTree != null) {
            this.debugTree.expandRow(0);
            this.debugTree.expandRow(1);
        }
        if (ErrorReporter.getErrorCount() > 0) {
            debug.report(4, "### ERROR during IR build. Exiting! ###");
            System.exit(1);
        }
        debug.report(4, "### Generate Code ###");
        long l5 = -System.currentTimeMillis();
        if (this.backend != null) {
            this.generateCode();
        }
        l5 += System.currentTimeMillis();
        debug.report(4, "### done. ###");
        if (this.printTiming) {
            System.out.println("timing information (millis):");
            System.out.println("start up: " + l);
            System.out.println("parse:    " + l2);
            System.out.println("manifest: " + l3);
            System.out.println("build IR: " + l4);
            System.out.println("code gen: " + l5);
        }
        this.exportPrefs();
    }

    private void exportPrefs() {
        if (this.prefsExport != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.prefsExport);){
                this.prefs.exportSubtree(fileOutputStream);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
    }

    private void importPrefs() {
        if (this.prefsImport != null) {
            try (FileInputStream fileInputStream = new FileInputStream(this.prefsImport);){
                Preferences.importPreferences(fileInputStream);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
    }

    private Main(String[] stringArray) {
        this.args = stringArray;
    }

    private static void staticInit() {
        String string = Main.class.getPackage().getName();
        System.setProperty("java.util.prefs.PreferencesFactory", string + ".util.MyPreferencesFactory");
    }

    public static void main(String[] stringArray) {
        Main.staticInit();
        Main main = new Main(stringArray);
        main.run();
    }
}

